import 'package:asteroids/game/models/player.dart';
import 'package:asteroids/game/services/game_service.dart';
import 'package:flutter_test/flutter_test.dart';

void main() {
  test('initializeAsteroids seeds game and timer', () {
    final service = GameService(initialPlayer: Player(x: 0, y: 0));

    service.initializeAsteroids(800, 600);

    expect(service.asteroidsInitialized, isTrue);
    expect(service.asteroids.length, GameService.asteroidCount);
    expect(service.elapsedTimeSeconds, greaterThanOrEqualTo(0));
  });

  test('shoot adds a bullet while playing', () {
    final service = GameService(initialPlayer: Player(x: 100, y: 100));

    service.initializeAsteroids(800, 600);
    service.shoot();

    expect(service.bullets.length, 1);
  });

  test('reset clears entities and restarts asteroids', () {
    final service = GameService(initialPlayer: Player(x: 100, y: 100));

    service.initializeAsteroids(800, 600);
    service.shoot();
    service.reset(Player(x: 50, y: 50), 800, 600);

    expect(service.isGameOver, isFalse);
    expect(service.bullets, isEmpty);
    expect(service.asteroidsInitialized, isTrue);
    expect(service.asteroids.length, GameService.asteroidCount);
  });

  test('updateAsteroids moves asteroids when playing', () {
    final service = GameService(initialPlayer: Player(x: 200, y: 200));

    service.initializeAsteroids(800, 600);
    final first = service.asteroids.first;

    service.updateAsteroids(0.016);
    final updated = service.asteroids.first;

    final moved = first.x != updated.x || first.y != updated.y;
    expect(moved, isTrue);
  });
}
