#!/usr/bin/env bash
# Extract worksheet IDs by region from worksheets.csv

set -euo pipefail

CSV_FILE="${1:-worksheets.csv}"
OUTPUT_DIR="export"

if [[ ! -f "$CSV_FILE" ]]; then
  echo "Error: $CSV_FILE not found"
  exit 1
fi

mkdir -p "$OUTPUT_DIR"

# Create JSON arrays
echo "[" > "$OUTPUT_DIR/au-ws-ids.json"
tail -n +2 "$CSV_FILE" | awk -F',' '$1 == "au" {print "  \"" $4 "\","}' | sed '$ s/,$//' >> "$OUTPUT_DIR/au-ws-ids.json"
echo "]" >> "$OUTPUT_DIR/au-ws-ids.json"

echo "[" > "$OUTPUT_DIR/us-ws-ids.json"
tail -n +2 "$CSV_FILE" | awk -F',' '$1 == "us" {print "  \"" $4 "\","}' | sed '$ s/,$//' >> "$OUTPUT_DIR/us-ws-ids.json"
echo "]" >> "$OUTPUT_DIR/us-ws-ids.json"

AU_COUNT=$(tail -n +2 "$CSV_FILE" | awk -F',' '$1 == "au"' | wc -l | tr -d ' ')
US_COUNT=$(tail -n +2 "$CSV_FILE" | awk -F',' '$1 == "us"' | wc -l | tr -d ' ')
TOTAL=$((AU_COUNT + US_COUNT))

echo "✓ Extracted $AU_COUNT AU worksheet IDs -> $OUTPUT_DIR/au-ws-ids.json"
echo "✓ Extracted $US_COUNT US worksheet IDs -> $OUTPUT_DIR/us-ws-ids.json"
echo "✓ Total: $TOTAL worksheets"
