#!/usr/bin/env bash
set -euo pipefail

###############################################################################
#                              CONFIGURATION
###############################################################################

# Firebase projects
FIREBASE_DEV_PROJECT="mathgaps-dev-b044f"
FIREBASE_PROD_PROJECT="mathgaps-56d5a"

# Credentials paths (relative to script directory)
FIREBASE_DEV_CREDS="../../secrets/sa-app.json"
FIREBASE_PROD_CREDS="../../secrets/sa-prod.json"

###############################################################################
#                              SCRIPT
###############################################################################

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

show_usage() {
    echo "Usage: $0 <environment> [--dry-run|--backup]"
    echo ""
    echo "Environments:"
    echo "  dev   - Dev Firebase (mathgaps-dev-b044f)"
    echo "  prod  - Prod Firebase (mathgaps-56d5a)"
    echo ""
    echo "Modes:"
    echo "  --dry-run  Count documents only (default)"
    echo "  --backup   Copy whiteboard-templates -> whiteboard-templates-backup"
}

ENV="${1:-}"
MODE="${2:---dry-run}"

if [[ -z "$ENV" ]]; then
    show_usage
    exit 1
fi

case "$ENV" in
    dev)
        FIREBASE_PROJECT="$FIREBASE_DEV_PROJECT"
        FIREBASE_CREDS="$FIREBASE_DEV_CREDS"
        ;;
    prod)
        FIREBASE_PROJECT="$FIREBASE_PROD_PROJECT"
        FIREBASE_CREDS="$FIREBASE_PROD_CREDS"
        ;;
    *)
        echo "Error: Unknown environment '$ENV'"
        show_usage
        exit 1
        ;;
esac

echo ""
echo "Environment: $ENV"
echo "Firebase:    $FIREBASE_PROJECT"
echo "Mode:        $MODE"
echo ""

cd "$SCRIPT_DIR"
go run backup-templates.go "$FIREBASE_CREDS" "$FIREBASE_PROJECT" "$MODE"
