#!/usr/bin/env python3
"""Test URL parsing for query-raw-logs"""

import json
from urllib.parse import quote

# Simulate the URL from Grafana
panes_data = {
    "6np": {
        "datasource": "loki",
        "queries": [{
            "refId": "A",
            "expr": "{app=\"resources-graphql\"} |= `[latex-processor]`",
            "queryType": "range",
            "datasource": {"type": "loki", "uid": "loki"},
            "editorMode": "builder",
            "direction": "backward"
        }],
        "range": {"from": "now-6h", "to": "now"}
    }
}

# Generate URL
test_url = f"https://telemetry.tutero.dev/grafana/explore?panes={quote(json.dumps(panes_data))}&orgId=1"

print("Generated test URL:")
print(test_url)
print("\n" + "="*80)
print("\nYou can test with:")
print(f"./query-raw-logs --url '{test_url}' --limit 5 --pretty")
