#!/bin/bash
# Query Loki for full OTEL JSON logs matching [latex-processor]

LOKI_URL="${LOKI_URL:-http://localhost:3100}"
TIME_RANGE="${1:-6h}"

# Calculate timestamps
if [[ "$OSTYPE" == "darwin"* ]]; then
    # macOS
    START_TIME=$(date -u -v-"${TIME_RANGE}" +%s)000000000
else
    # Linux
    START_TIME=$(date -u -d "${TIME_RANGE} ago" +%s)000000000
fi
END_TIME=$(date -u +%s)000000000

echo "🔍 Querying Loki for [latex-processor] logs..." >&2
echo "   Time range: last ${TIME_RANGE}" >&2
echo "   Query: {app=\"resources-graphql\"} |= \`[latex-processor]\`" >&2
echo "" >&2

# Query and extract raw log lines
curl -s -G "${LOKI_URL}/loki/api/v1/query_range" \
  --data-urlencode 'query={app="resources-graphql"} |= `[latex-processor]`' \
  --data-urlencode "start=${START_TIME}" \
  --data-urlencode "end=${END_TIME}" \
  --data-urlencode 'limit=100' \
  --data-urlencode 'direction=backward' \
  | jq -r '.data.result[].values[][1]' \
  | jq '.'

echo "" >&2
echo "✅ Done" >&2
