#!/bin/bash
# Example usage of query-raw-logs with Grafana URL

echo "Example 1: Query with your exact Grafana URL"
echo "=============================================="
echo ""

# Your actual URL from Grafana
URL='https://telemetry.tutero.dev/grafana/explore?schemaVersion=1&panes=%7B%226np%22%3A%7B%22datasource%22%3A%22loki%22%2C%22queries%22%3A%5B%7B%22refId%22%3A%22A%22%2C%22expr%22%3A%22%7Bapp%3D%5C%22resources-graphql%5C%22%7D+%7C%3D+%60%5Blatex-processor%5D%60%22%2C%22queryType%22%3A%22range%22%2C%22datasource%22%3A%7B%22type%22%3A%22loki%22%2C%22uid%22%3A%22loki%22%7D%2C%22editorMode%22%3A%22builder%22%2C%22direction%22%3A%22backward%22%7D%5D%2C%22range%22%3A%7B%22from%22%3A%22now-6h%22%2C%22to%22%3A%22now%22%7D%2C%22panelsState%22%3A%7B%22logs%22%3A%7B%22columns%22%3A%7B%220%22%3A%22Time%22%2C%221%22%3A%22Line%22%7D%2C%22visualisationType%22%3A%22table%22%2C%22labelFieldName%22%3A%22labels%22%7D%7D%7D%7D&orgId=1'

echo "Command:"
echo "./query-raw-logs --url '$URL' --limit 5 --pretty"
echo ""
echo "This will:"
echo "  - Extract query: {app=\"resources-graphql\"} |= \`[latex-processor]\`"
echo "  - Extract time: 6h (from now-6h)"
echo "  - Fetch 5 most recent logs"
echo "  - Pretty print the OTEL JSON"
echo ""
echo "------------------------------------------------------------"
echo ""

echo "Example 2: Same query but override time range"
echo "=============================================="
echo ""
echo "./query-raw-logs --url '$URL' --time 1h --limit 10"
echo ""
echo "  - Uses same query from URL"
echo "  - But only last 1 hour (overrides the 6h from URL)"
echo "  - Fetch 10 logs"
echo ""
echo "------------------------------------------------------------"
echo ""

echo "Example 3: Pipe to jq for analysis"
echo "=============================================="
echo ""
echo "./query-raw-logs --url '$URL' | jq -s '.[].message'"
echo ""
echo "  - Get all messages from the logs"
echo ""
echo "------------------------------------------------------------"
echo ""

echo "Example 4: Save to file"
echo "=============================================="
echo ""
echo "./query-raw-logs --url '$URL' --pretty > latex-processor-logs.json"
echo ""
echo "  - Saves all logs to latex-processor-logs.json"
echo ""
echo "------------------------------------------------------------"
echo ""

echo "TIP: Make sure port-forward is running first:"
echo "kubectl port-forward -n observability svc/loki-gateway 3100:80 --context=dev"
