# LLM Data Extraction - See the ACTUAL Shit That Broke

No more reports. No more summaries. Just the **raw data**.

## Location

`~/Coding/metarepo/scripts/llm-show-failures`

## What It Does

Shows you the **ACTUAL DATA** that failed:
- The exact JSON that couldn't be parsed
- The bad LaTeX that failed validation
- The full LLM prompts and responses
- Complete trace data with everything

## Commands

### See Failed JSON (Unmarshal Errors)

```bash
./llm-show-failures unmarshal
./llm-show-failures unmarshal --time 1h
```

**Shows you:**
- The EXACT JSON string the LLM returned
- What error occurred when trying to parse it
- Node ID, lesson plan ID, trace ID
- Full context

### See Failed LaTeX

```bash
./llm-show-failures latex
./llm-show-failures latex --time 2h
```

**Shows you:**
- The ACTUAL bad LaTeX (even after correction attempt)
- What made it through validation initially
- What the correction LLM tried to fix it to
- Why it still failed

### See LLM Prompts & Responses

```bash
./llm-show-failures prompts
./llm-show-failures prompts --time 30m
```

**Shows you:**
- Full system prompts sent to LLM
- User prompts
- Complete raw output from LLM
- Model, provider, node type

### Dump Latest Failures (Everything)

```bash
./llm-show-failures dump
./llm-show-failures dump --time 5m
```

**Shows you:**
- Last 5 errors with COMPLETE JSON dump
- Every field in the log
- All metadata
- Everything

### Trace Specific Request (Deep Dive)

```bash
./llm-show-failures trace <trace-id>
```

**Shows you:**
- ALL logs for that trace
- Every field from every log entry
- Complete timeline
- All prompts, responses, errors

## Real Examples

### Example 1: "What JSON did the LLM return that broke?"

```bash
# Get recent unmarshal failures
./llm-show-failures unmarshal --time 1h
```

**Output:**
```
================================================================================
FAILURE #1
================================================================================

📄 RAW JSON THAT FAILED:
--------------------------------------------------------------------------------
{
  "easy": {
    "picked_skill": "Finding volume using unit cubes",
    "question": "A box is $2$ units long...",
    "answer": "$24$"
    "extra_field": "oops"  <--- MISSING COMMA
  }
}

❌ ERROR:
--------------------------------------------------------------------------------
invalid character '"' after object key:value pair

📍 NODE ID: 01K8QCAXFVSXZMTAAC81EYWVEZ
🔗 TRACE ID: bc230ad0acae5a94d08d8513e16830b2
```

Now you SEE the actual problem - missing comma.

---

### Example 2: "What bad LaTeX is causing failures?"

```bash
./llm-show-failures latex --time 30m
```

**Output:**
```
================================================================================
LATEX FAILURE #1
================================================================================

🔴 BAD LATEX (even after correction attempt):
--------------------------------------------------------------------------------
Park rangers estimate the water held behind an epic waterfall by counting 
$1$ m^3 cubes that fit into the pool.

^ MISSING $ after m^3 - should be m$^3$

🔗 TRACE ID: bc230ad0acae5a94d08d8513e16830b2
📍 NODE ID: 01K8QCAXFVSXZMTAAC7M4MBVV9
```

Now you SEE the exact LaTeX that's malformed.

---

### Example 3: "What prompt caused this response?"

```bash
./llm-show-failures prompts --time 1h
```

**Output:**
```
================================================================================
LLM CALL #1
================================================================================
📍 Model: openai/gpt-oss-120b
📍 Provider: groq
📍 Node Type: *lessonplan.ActivityNode

🎤 SYSTEM PROMPT:
--------------------------------------------------------------------------------
You are a math educator designing a classroom activity for Grade 5...
(full prompt shown)

🎤 USER PROMPT:
--------------------------------------------------------------------------------
[Skills] = [ Finding volume using unit cubes ]
(full prompt shown)

📤 LLM OUTPUT:
--------------------------------------------------------------------------------
{
  "reasoning": "We chose the single skill...",
  "picked_skills": "Finding volume using unit cubes",
  "header": "Cube Count Challenge",
  ...
}
```

Now you SEE what you sent and what came back.

---

### Example 4: "Give me EVERYTHING about this failure"

```bash
# Get a trace ID from any error
./llm-show-failures dump --time 5m

# Copy the trace ID, then:
./llm-show-failures trace bc230ad0acae5a94d08d8513e16830b2
```

**Output:**
```
================================================================================
🔍 COMPLETE TRACE DATA: bc230ad0acae5a94d08d8513e16830b2
================================================================================

Found 47 log entries

================================================================================
#1 [DEBUG] 2025-10-29T07:01:31Z
================================================================================
Message: [prompt-input-and-output]

📌 model:
--------------------------------------------------------------------------------
"openai/gpt-oss-120b"

📌 rawOutput:
--------------------------------------------------------------------------------
{... full JSON response ...}

📌 promptType:
--------------------------------------------------------------------------------
"lesson_plan"

... (continues for all 47 logs)
```

Complete data dump. Everything.

---

## Quick Workflow

### When Something Fails

```bash
# 1. What failed recently?
./llm-show-failures dump

# 2. Got a trace ID? Dig in
./llm-show-failures trace <trace-id>

# 3. Specific type of failure?
./llm-show-failures unmarshal    # JSON problems
./llm-show-failures latex        # LaTeX problems
./llm-show-failures prompts      # See what was sent/received
```

### Debugging Specific Issues

**JSON Parse Errors:**
```bash
./llm-show-failures unmarshal --time 2h
# Read the actual JSON, find the syntax error
```

**LaTeX Validation:**
```bash
./llm-show-failures latex --time 1h
# See the exact bad LaTeX, find what's wrong
```

**LLM Not Following Instructions:**
```bash
./llm-show-failures prompts --time 30m
# Compare prompt vs response, see what went wrong
```

**Trace Full Request:**
```bash
./llm-show-failures trace <trace-id>
# See everything: prompts, retries, errors, corrections
```

---

## Setup

### Prerequisites

Port-forward must be running:
```bash
kubectl port-forward -n observability svc/loki-gateway 3100:80 --context=dev
```

### Quick Alias

Add to `~/.zshrc`:
```bash
alias show-fails='python3 ~/Coding/metarepo/scripts/llm-show-failures'
```

Then use:
```bash
show-fails unmarshal
show-fails latex
show-fails dump
```

Or use the wrapper:
```bash
~/Coding/metarepo/scripts/show-llm-fails unmarshal
```

---

## Output Format

### Raw Data, Not Summaries

**You get:**
- Actual strings/JSON that failed
- Full error messages
- Complete log entries
- All metadata fields
- Trace IDs for correlation

**NOT:**
- Counts
- Percentages  
- Summaries
- Reports

### When You Need Reports

Use the other tool:
```bash
~/Coding/mathgaps-org/backend/app/resources/llm-monitor stats
```

When you need **data**, use this:
```bash
./llm-show-failures dump
```

---

## Tips

### 1. Pipe to Less for Long Output

```bash
./llm-show-failures prompts --time 1h | less
```

### 2. Save to File

```bash
./llm-show-failures dump > failures-$(date +%Y%m%d-%H%M).txt
```

### 3. Grep for Specific Issues

```bash
./llm-show-failures unmarshal --time 2h | grep -A 20 "missing"
```

### 4. Use with jq

```bash
# Get raw JSON logs, process with jq
klogs search --message "[prompt-input-and-output]" --time 30m --json | jq .
```

### 5. Compare Prompt vs Response

```bash
./llm-show-failures prompts --time 5m > /tmp/prompts.txt
# Read and compare what you asked vs what you got
```

---

## Troubleshooting

### No Data Shown

**Check:**
1. Port-forward running?
2. Time range wide enough? Try `--time 2h`
3. Actually have failures? Check: `./llm-monitor failures`

### Permission Denied

```bash
chmod +x ~/Coding/metarepo/scripts/llm-show-failures
python3 ~/Coding/metarepo/scripts/llm-show-failures --help
```

### klogs Not Found

Edit the script, line 11:
```python
KLOGS_PATH = "/path/to/your/klogs"
```

---

## Difference from llm-monitor

### llm-monitor (Reports)

```bash
./llm-monitor stats
./llm-monitor failures
```

**Purpose:** Health checks, statistics, patterns  
**Output:** Summaries, counts, status

### llm-show-failures (Raw Data)

```bash
./llm-show-failures unmarshal
./llm-show-failures dump
```

**Purpose:** Debugging, seeing actual data  
**Output:** Raw JSON, strings, complete logs

---

## Use Cases

### Use llm-show-failures when:

- ✅ Need to see exact JSON that failed
- ✅ Want to see bad LaTeX content
- ✅ Need full prompts and responses
- ✅ Debugging specific failure
- ✅ Need to copy/paste actual data

### Use llm-monitor when:

- ✅ Checking system health
- ✅ Want error rates/statistics
- ✅ Monitoring over time
- ✅ Tracking patterns
- ✅ Getting overview

---

## Examples by Problem Type

### "LLM returning invalid JSON"

```bash
./llm-show-failures unmarshal
# Read the JSON, find syntax error
# Common: missing comma, unescaped quote, extra bracket
```

### "LaTeX validation keeps failing"

```bash
./llm-show-failures latex
# See the exact LaTeX
# Common: missing $, unmatched braces, \n in wrong place
```

### "LLM not following prompt"

```bash
./llm-show-failures prompts
# Compare prompt vs response
# See if instructions are clear enough
```

### "Retry loop won't stop"

```bash
./llm-show-failures dump
# Get trace ID
./llm-show-failures trace <trace-id>
# See what error keeps recurring
```

---

## Quick Reference

```bash
# THE GOOD STUFF (actual data):
./llm-show-failures unmarshal      # Failed JSON
./llm-show-failures latex          # Bad LaTeX
./llm-show-failures prompts        # Full prompts/responses
./llm-show-failures dump           # Everything, latest 5
./llm-show-failures trace <id>     # Complete trace data

# THE REPORTS (for health checks):
llm-monitor stats                  # Statistics
llm-monitor failures               # Failure patterns
llm-monitor latex-failures         # LaTeX failure patterns
```

---

**Now you see the ACTUAL data. No bullshit.** 🔥
