# Query Loki from Grafana URLs

## Usage

Simply copy the Grafana Explore URL and paste it into the command:

```bash
./query-raw-logs --url 'https://telemetry.tutero.dev/grafana/explore?schemaVersion=1&panes=%7B%226np%22%3A%7B%22datasource%22%3A%22loki%22%2C%22queries%22%3A%5B%7B%22refId%22%3A%22A%22%2C%22expr%22%3A%22%7Bapp%3D%5C%22resources-graphql%5C%22%7D+%7C%3D+%60%5Blatex-processor%5D%60%22%2C%22queryType%22%3A%22range%22%2C%22datasource%22%3A%7B%22type%22%3A%22loki%22%2C%22uid%22%3A%22loki%22%7D%2C%22editorMode%22%3A%22builder%22%2C%22direction%22%3A%22backward%22%7D%5D%2C%22range%22%3A%7B%22from%22%3A%22now-6h%22%2C%22to%22%3A%22now%22%7D%2C%22panelsState%22%3A%7B%22logs%22%3A%7B%22columns%22%3A%7B%220%22%3A%22Time%22%2C%221%22%3A%22Line%22%7D%2C%22visualisationType%22%3A%22table%22%2C%22labelFieldName%22%3A%22labels%22%7D%7D%7D%7D&orgId=1'
```

The tool will automatically:
- Extract the LogQL query from the URL
- Extract the time range (e.g., `now-6h`)
- Query your local Loki instance (via port-forward)
- Output the raw OTEL JSON logs

## Pretty Print

Add `--pretty` to format the JSON nicely:

```bash
./query-raw-logs --url 'YOUR_GRAFANA_URL' --pretty
```

## Limit Results

Control how many logs to fetch:

```bash
./query-raw-logs --url 'YOUR_GRAFANA_URL' --limit 10 --pretty
```

## Override Time Range

Override the time range from the URL:

```bash
./query-raw-logs --url 'YOUR_GRAFANA_URL' --time 1h --pretty
```

## Save to File

```bash
./query-raw-logs --url 'YOUR_GRAFANA_URL' --pretty > logs.json
```

## What Gets Extracted

From a Grafana URL like:
```
{app="resources-graphql"} |= `[latex-processor]`
```

Time range:
```
now-6h → 6h
now-30m → 30m
now-2d → 2d
```

## Requirements

- Port-forward to Loki must be running:
  ```bash
  kubectl port-forward -n observability svc/loki-gateway 3100:80 --context=dev
  ```

## Output

The tool outputs raw OTEL JSON logs to stdout, one JSON object per line:

```json
{"severity":"INFO","time":"2024-01-15T10:30:00Z","message":"Processing latex","traceID":"abc123",...}
{"severity":"ERROR","time":"2024-01-15T10:31:00Z","message":"Latex validation failed","traceID":"abc123",...}
```

With `--pretty`:
```json
{
  "severity": "INFO",
  "time": "2024-01-15T10:30:00Z",
  "message": "Processing latex",
  "traceID": "abc123",
  ...
}
```

## Pipe to jq for Analysis

```bash
# Count errors
./query-raw-logs --url 'URL' | jq -s 'map(select(.severity=="ERROR")) | length'

# Extract trace IDs
./query-raw-logs --url 'URL' | jq -r '.traceID' | sort -u

# Find specific field
./query-raw-logs --url 'URL' | jq 'select(.nodeID != null) | {nodeID, message}'
```
